;
;***********************
; DEMO LED & 7 SEGMENT *
;     EXPERIMENT 2     *
;***********************

       CPU  "Z180.TBL"
       HOF  "INT8"

        ORG  8000H
PCTRL:  EQU  0BBH
SEG:    EQU  0B9H
LED:    EQU  0BAH
DMSEC:  EQU  012EH


START: LD   A,80H
       OUT  (PCTRL),A
;
       LD   C,16                  ;16 DATA
       LD   HL,TAB_SEG
       LD   DE,TAB_LED
;
LOOP:  LD   A,(HL)
       OUT  (SEG),A
       LD   A,(DE)
       OUT  (LED),A
       LD   B,200
       CALL DMSEC
       INC  HL
       INC  DE
       LD   A,C
       CP   9
       CALL Z,WAIT
       DEC  C
       JR   NZ,LOOP
       JR   START

;
;/* LED END LEFT */

WAIT:  XOR  A
       OUT  (LED),A
       LD   B,100
       CALL DMSEC
       RET
;
;/* DATA TABLE */

TAB_SEG: DFB  3FH,06H,5BH,4FH     ;SEGMENT
         DFB  66H,6DH,7DH,07H
         DFB  7FH,6FH,77H,7CH
         DFB  39H,5EH,79H,71H

TAB_LED: DFB  01H,02H,04H,08H     ;LED
         DFB  10H,20H,40H,80H
         DFB  80H,40H,20H,10H
         DFB  08H,04H,02H,01H
       END
